package w83b.w83bDAO;

import java.util.HashMap;
import java.util.Map;


public abstract class W83bFactoriaDAO  {

	private static Map implementaciones=new HashMap();
	
	//DISPATCH IMPLEMENTACIONES
	private static Object get(String clase) throws Exception{
		Object objeto = W83bFactoriaDAO.implementaciones.get(clase);		
		if(objeto==null){
			if ("mantenimientos".equals(clase))
			{
				objeto = W83bMantenimientosDAO.class.newInstance();
				
			}
			else if ("preavisos".equals(clase)){
					objeto = W83bPreavisosDAO.class.newInstance();		
			}else if("actas".equals(clase)){
				objeto = W83bActasDAO.class.newInstance();
			}else if("comunes".equals(clase)){
				objeto = W83bComunesDAO.class.newInstance();
			}else if("listados".equals(clase)){
				objeto = W83bListadosDAO.class.newInstance();
			}else if("registroDefinitivo".equals(clase)){
				objeto = W83bRegistroDefinitivoDAO.class.newInstance();
			}else if("impugnaciones".equals(clase)){
				objeto = W83bImpugnacionesDAO.class.newInstance();
			}else if("citaciones".equals(clase)){
				objeto = W83bCitacionesDAO.class.newInstance();
			}else if("resultados".equals(clase)){
				objeto = W83bResultadosDAO.class.newInstance();
			}else if("datosMinisterio".equals(clase)){
				objeto = W83bDatosMinisterioDAO.class.newInstance();
			}else if("incidencias".equals(clase)){
				objeto = W83bIncidenciasDAO.class.newInstance();
			}else if("cierre".equals(clase)){
				objeto = W83bCierreDAO.class.newInstance();
			}else if("migracion".equals(clase)){
				objeto = W83bMigracionDAO.class.newInstance();
			}else if("certificaciones".equals(clase)){
				objeto = W83bCertificacionesDAO.class.newInstance();
			}else if("comunicaciones".equals(clase)){
				objeto = W83bComunicacionesDAO.class.newInstance();
			}else if("historicos".equals(clase)){
				objeto = W83bHistoricosDAO.class.newInstance();
			}else if("bandejaEntrada".equals(clase)){
				objeto = W83bBandejaEntradaDAO.class.newInstance();
			}else if ("lotesPreavisos".equals(clase)){
				objeto = W83bLotesPreavisosDAO.class.newInstance();
			}else if ("delegadosPrevencion".equals(clase)){
				objeto = W83bDelegadosPrevencionDAO.class.newInstance();
			}else if ("sindicatos".equals(clase)){
				objeto = W83bSindicatosDAO.class.newInstance();
			}else if ("delegados".equals(clase)){
				objeto = W83bDelegadosDAO.class.newInstance();
			}
			W83bFactoriaDAO.implementaciones.put(clase,objeto);
		}
		return (Object)objeto;
	}
	
	
	//FIN DISPATCH IMPLEMENTACIONES
	
	public static W83bIComunesDAO getComunesDAO() throws Exception{
		return (W83bIComunesDAO)W83bFactoriaDAO.get("comunes");
	}
	
	public static W83bIMantenimientosDAO getMantenimientosDAO() throws Exception{
		return (W83bIMantenimientosDAO)W83bFactoriaDAO.get("mantenimientos");
	}
	
	public static W83bIActasDAO getActasDAO() throws Exception{
		return (W83bIActasDAO)W83bFactoriaDAO.get("actas");
	}
	
	public static W83bIImpugnacionesDAO getImpugnacionesDAO() throws Exception{
		return (W83bIImpugnacionesDAO)W83bFactoriaDAO.get("impugnaciones");
	}
	
	public static W83bICitacionesDAO getCitacionesDAO() throws Exception{
		return (W83bICitacionesDAO)W83bFactoriaDAO.get("citaciones");
	}
	
	public static W83bIPreavisosDAO getPreavisosDAO() throws Exception{
		return (W83bIPreavisosDAO)W83bFactoriaDAO.get("preavisos");
	}
	
	public static W83bIListadosDAO getListadosDAO() throws Exception{
		return (W83bIListadosDAO)W83bFactoriaDAO.get("listados");
	}
	
	
	public static W83bIRegistroDefinitivoDAO getRegistroDefinitivoDAO() throws Exception{
		return (W83bIRegistroDefinitivoDAO)W83bFactoriaDAO.get("registroDefinitivo");
	}
	
	public static W83bIResultadosDAO getResultadosDAO() throws Exception{
		return (W83bIResultadosDAO)W83bFactoriaDAO.get("resultados");
	}
	
	public static W83bIIncidenciasDAO getIncidenciasDAO() throws Exception{
		return (W83bIIncidenciasDAO)W83bFactoriaDAO.get("incidencias");
	}
	public static W83bIDatosMinisterioDAO getDatosMinisterioDAO() throws Exception{
		return (W83bIDatosMinisterioDAO)W83bFactoriaDAO.get("datosMinisterio");
	}
	public static W83bICierreDAO getCierreDAO() throws Exception{
		return (W83bICierreDAO)W83bFactoriaDAO.get("cierre");
	}
	public static W83bIMigracionDAO getMigracionDAO() throws Exception{
		return (W83bIMigracionDAO)W83bFactoriaDAO.get("migracion");
	}
	public static W83bICertificacionesDAO getCertificacionesDAO() throws Exception{
		return (W83bICertificacionesDAO)W83bFactoriaDAO.get("certificaciones");
	}
	public static W83bIComunicacionesDAO getComunicacionesDAO() throws Exception{
		return (W83bIComunicacionesDAO)W83bFactoriaDAO.get("comunicaciones");
	}
	public static W83bIHistoricosDAO getHistoricosDAO() throws Exception{
		return (W83bIHistoricosDAO)W83bFactoriaDAO.get("historicos");
	}
	public static W83bIBandejaEntradaDAO getBandejaEntradaDAO() throws Exception{
		return (W83bIBandejaEntradaDAO)W83bFactoriaDAO.get("bandejaEntrada");
	}
	public static W83bILotesPreavisosDAO getLotesPreavisosDAO() throws Exception{
		return (W83bILotesPreavisosDAO)W83bFactoriaDAO.get("lotesPreavisos");
	}
	public static W83bIDelegadosPrevencionDAO getDelegadosPrevencionDAO() throws Exception{
		return (W83bIDelegadosPrevencionDAO)W83bFactoriaDAO.get("delegadosPrevencion");
	}
	public static W83bIDelegadosDAO getDelegadosDAO() throws Exception{
		return (W83bIDelegadosDAO)W83bFactoriaDAO.get("delegados");
	}
	public static W83bISindicatosDAO getSindicatosDAO() throws Exception{
		return (W83bISindicatosDAO)W83bFactoriaDAO.get("sindicatos");
	}
}